/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.util;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class Waypoint {
    private String name;
    private String color;
    private String original;
    private String zan;
    private String colorPart;
    private String compareStr;
    private String serverLine;
    private int xCord;
    private int yCord;
    private int zCord;
    private int dim;
    private int zanXCord;
    private int zanYCord;
    private int zanZCord;
    private int[] dims;
    private float rColor;
    private float gColor;
    private float bColor;
    private boolean visible;
    private boolean zanPoint;
    private boolean death;
    private boolean isPublic;
    private String[] parts;
    private String[] dimensions;
    private StringBuilder originals;

    public Waypoint(String pNetwork, int pDim) {
        this.zanPoint = false;
        this.original = pNetwork.substring(0, pNetwork.lastIndexOf(":"));
        this.parts = new String[7];
        this.parts = pNetwork.split(":", 7);
        this.name = this.parts[0].replaceAll("~colon~", ":");
        this.xCord = Integer.parseInt(this.parts[1]);
        this.yCord = Integer.parseInt(this.parts[2]);
        this.zCord = Integer.parseInt(this.parts[3]);
        this.visible = this.parts[4].equalsIgnoreCase("true");
        this.color = this.parts[5];
        this.isPublic = this.parts[6].equals("true");
        this.dim = pDim;
        this.dims = new int[1];
        this.dims[0] = this.dim;
        this.buildRGB();
        this.buildCompareStr();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            if (this.dim == -1) {
                this.convertToZanNether();
            } else {
                this.zanXCord = this.xCord;
                this.zanYCord = this.yCord;
                this.zanZCord = this.zCord;
            }
        } else {
            this.zanXCord = this.xCord;
            this.zanYCord = this.yCord;
            this.zanZCord = this.zCord;
        }
        this.buildServerLine();
    }

    public Waypoint(String pWaypoint, int pDim, boolean isPublic) {
        this.zanPoint = false;
        this.original = pWaypoint;
        this.parts = new String[6];
        this.parts = pWaypoint.split(":", 6);
        this.name = this.parts[0].replaceAll("~colon~", ":");
        this.xCord = Integer.parseInt(this.parts[1]);
        this.yCord = Integer.parseInt(this.parts[2]);
        this.zCord = Integer.parseInt(this.parts[3]);
        this.visible = this.parts[4].equalsIgnoreCase("true");
        this.isPublic = isPublic;
        this.color = this.parts[5];
        this.dim = pDim;
        this.dims = new int[1];
        this.dims[0] = this.dim;
        this.buildRGB();
        this.buildCompareStr();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            if (this.dim == -1) {
                this.convertToZanNether();
            } else {
                this.zanXCord = this.xCord;
                this.zanYCord = this.yCord;
                this.zanZCord = this.zCord;
            }
        } else {
            this.zanXCord = this.xCord;
            this.zanYCord = this.yCord;
            this.zanZCord = this.zCord;
        }
        this.buildServerLine();
    }

    public Waypoint(String pWaypoint, boolean isPublic) {
        this.isPublic = isPublic;
        this.zanPoint = false;
        int splitPoint = pWaypoint.lastIndexOf(58);
        this.original = pWaypoint.substring(0, splitPoint);
        this.parts = new String[7];
        this.parts = pWaypoint.split(":", 7);
        this.name = this.parts[0].replaceAll("~colon~", ":");
        this.xCord = Integer.parseInt(this.parts[1]);
        this.yCord = Integer.parseInt(this.parts[2]);
        this.zCord = Integer.parseInt(this.parts[3]);
        this.visible = this.parts[4].equalsIgnoreCase("true");
        this.color = this.parts[5];
        this.dim = Integer.parseInt(this.parts[6]);
        this.dims = new int[1];
        this.dims[0] = this.dim;
        this.buildRGB();
        this.buildCompareStr();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            if (this.dim == -1) {
                this.convertToZanNether();
            } else {
                this.zanXCord = this.xCord;
                this.zanYCord = this.yCord;
                this.zanZCord = this.zCord;
            }
        } else {
            this.zanXCord = this.xCord;
            this.zanYCord = this.yCord;
            this.zanZCord = this.zCord;
        }
        this.buildServerLine();
    }

    public Waypoint(boolean pZan, String pName, int x, int y, int z, boolean enabled, float r, float g, float b, String suffix, TreeSet<Integer> dimensions, int pDim, boolean isPublic) {
        this.isPublic = isPublic;
        this.zanPoint = pZan;
        this.name = pName;
        this.zanXCord = x;
        this.zanYCord = y;
        this.zanZCord = z;
        this.visible = enabled;
        this.rColor = r;
        this.gColor = g;
        this.bColor = b;
        this.death = suffix.contains("skull");
        this.dim = pDim;
        this.dims = new int[dimensions.size()];
        Iterator<Integer> iterator = dimensions.iterator();
        for (int i = 0; i < dimensions.size(); ++i) {
            this.dims[i] = iterator.next();
        }
        this.buildColor();
        this.buildOriginal();
        if (pDim == -1) {
            this.convertToNormalNether();
        } else {
            this.xCord = this.zanXCord;
            this.yCord = this.zanYCord;
            this.zCord = this.zanZCord;
        }
        this.buildCompareStr();
        this.buildServerLine();
    }

    public Waypoint(String pName, int x, int y, int z, boolean enabled, String col, int pDim) {
        this.name = pName;
        this.xCord = x;
        this.yCord = y;
        this.zCord = z;
        this.visible = enabled;
        this.color = col;
        this.dim = pDim;
        if (pDim == -1) {
            this.convertToZanNether();
        } else {
            this.zanXCord = this.xCord;
            this.zanYCord = this.yCord;
            this.zanZCord = this.zCord;
        }
        this.buildRGB();
        this.buildOriginal();
        this.buildCompareStr();
        this.buildServerLine();
    }

    public Waypoint(String pName, int x, int y, int z, boolean enabled, int r, int g, int b, Collection<Integer> dimensions, int pDim, boolean isPublic) {
        this.isPublic = isPublic;
        this.name = pName;
        this.xCord = x;
        this.yCord = y;
        this.zCord = z;
        this.visible = enabled;
        this.rColor = (float)r / 255.0f;
        this.gColor = (float)g / 255.0f;
        this.bColor = (float)b / 255.0f;
        this.zanPoint = true;
        this.buildColor();
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.addAll(dimensions);
        this.dims = new int[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            this.dims[i] = (Integer)temp.get(i);
        }
        this.dim = pDim;
        this.buildOriginal();
        this.buildCompareStr();
        this.buildServerLine();
    }

    public Waypoint(String pName, int x, int y, int z, int pDim, boolean isPublic) {
        this.isPublic = isPublic;
        this.name = pName;
        this.xCord = x;
        this.yCord = y;
        this.zCord = z;
        this.dim = pDim;
        this.buildCompareStr();
    }

    private void buildColor() {
        this.colorPart = Integer.toHexString(this.getFirstColor());
        this.color = this.colorPart.length() == 2 ? this.colorPart : (this.colorPart = "0" + this.colorPart);
        this.colorPart = Integer.toHexString(this.getSecondColor());
        if (this.colorPart.length() == 2) {
            this.color = this.color + this.colorPart;
        } else {
            this.colorPart = "0" + this.colorPart;
            this.color = this.color + this.colorPart;
        }
        this.colorPart = Integer.toHexString(this.getThirdColor());
        if (this.colorPart.length() == 2) {
            this.color = this.color + this.colorPart;
        } else {
            this.colorPart = "0" + this.colorPart;
            this.color = this.color + this.colorPart;
        }
    }

    private void buildCompareStr() {
        this.compareStr = this.name;
        this.compareStr = this.compareStr + ":";
        this.compareStr = this.compareStr + this.xCord;
        this.compareStr = this.compareStr + ":";
        this.compareStr = this.compareStr + this.yCord;
        this.compareStr = this.compareStr + ":";
        this.compareStr = this.compareStr + this.zCord;
    }

    private void buildOriginal() {
        this.originals = new StringBuilder();
        this.originals.append(this.name);
        this.originals.append(":");
        this.originals.append(this.zanXCord);
        this.originals.append(":");
        this.originals.append(this.zanYCord);
        this.originals.append(":");
        this.originals.append(this.zanZCord);
        this.originals.append(":");
        this.originals.append(this.visible);
        this.originals.append(":");
        this.originals.append(this.color);
        this.original = this.originals.toString();
    }

    private void buildRGB() {
        this.rColor = (float)this.getFirstColor() / 255.0f;
        this.gColor = (float)this.getSecondColor() / 255.0f;
        this.bColor = (float)this.getThirdColor() / 255.0f;
    }

    private void buildServerLine() {
        this.originals = new StringBuilder();
        this.originals.append(this.name.replaceAll(":", "~colon~"));
        this.originals.append(":");
        this.originals.append(this.xCord);
        this.originals.append(":");
        this.originals.append(this.yCord);
        this.originals.append(":");
        this.originals.append(this.zCord);
        this.originals.append(":");
        this.originals.append(this.visible);
        this.originals.append(":");
        this.originals.append(this.color);
        this.serverLine = this.originals.toString();
    }

    public void convertToNormalNether() {
        this.xCord = this.zanXCord / 8;
        this.yCord = this.zanYCord;
        this.zCord = this.zanZCord / 8;
    }

    public void convertToZanNether() {
        this.zanXCord = this.xCord * 8;
        this.zanYCord = this.yCord;
        this.zanZCord = this.zCord * 8;
    }

    public float getB() {
        return this.bColor;
    }

    public String getColor() {
        return this.color;
    }

    public String getCompareStr() {
        return this.compareStr;
    }

    public int getDim() {
        return this.dim;
    }

    public int[] getDims() {
        return this.dims;
    }

    public int getFirstColor() {
        if (this.zanPoint) {
            return (int)(this.rColor * 255.0f);
        }
        return Integer.parseInt(this.color.substring(0, 2), 16);
    }

    public float getG() {
        return this.gColor;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginal() {
        return this.original;
    }

    public float getR() {
        return this.rColor;
    }

    public int getSecondColor() {
        if (this.zanPoint) {
            return (int)(this.gColor * 255.0f);
        }
        return Integer.parseInt(this.color.substring(2, 4), 16);
    }

    public String getServerLine() {
        return this.serverLine;
    }

    public int getThirdColor() {
        if (this.zanPoint) {
            return (int)(this.bColor * 255.0f);
        }
        return Integer.parseInt(this.color.substring(4), 16);
    }

    public boolean getVisible() {
        return this.visible;
    }

    public int getXCord() {
        return this.xCord;
    }

    public int getYCord() {
        return this.yCord;
    }

    public int getZanXCord() {
        return this.zanXCord;
    }

    public int getZanYCord() {
        return this.zanYCord;
    }

    public int getZanZCord() {
        return this.zanZCord;
    }

    public int getZCord() {
        return this.zCord;
    }

    public void setColor(String pColor) {
        this.color = pColor;
    }

    public void setCords(int pXCord, int pYCord, int pZCord) {
        this.xCord = pXCord;
        this.yCord = pYCord;
        this.zCord = pZCord;
    }

    public void setDim(int pDim) {
        this.dim = pDim;
    }

    public void setName(String pName) {
        this.name = pName;
    }

    public void setOriginal(String pOriginal) {
        this.original = pOriginal;
    }

    public void setVisible(boolean pVisible) {
        this.visible = pVisible;
    }

    public boolean zan() {
        return this.zanPoint;
    }

    public boolean isDeath() {
        return this.death;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public Waypoint clone() {
        return new Waypoint(this.getNetworkLine(), this.dim);
    }

    public String getNetworkLine() {
        return this.serverLine + ":" + (this.isPublic ? "true" : "false");
    }
}

