/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.util;

import james94jeans2.minimapsync.util.Waypoint;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class WaypointList
implements Iterable<Waypoint> {
    private int dim;
    private LinkedList<Waypoint> list;
    private boolean isPublic;
    private String username;

    public WaypointList(int pDim, boolean pIsPublic) {
        this.dim = pDim;
        this.list = new LinkedList();
        this.username = "";
        this.isPublic = pIsPublic;
    }

    private WaypointList(int pDim, boolean pIsPublic, LinkedList<Waypoint> pList) {
        this.dim = pDim;
        this.list = pList;
        this.username = "";
        this.isPublic = pIsPublic;
    }

    public WaypointList(int pDim, String pUsername) {
        this.dim = pDim;
        this.list = new LinkedList();
        this.username = pUsername;
        this.isPublic = false;
    }

    private WaypointList(int pDim, String pUsername, LinkedList<Waypoint> pList) {
        this.dim = pDim;
        this.list = pList;
        this.username = pUsername;
        this.isPublic = false;
    }

    public void add(Waypoint pWaypoint) {
        this.list.add(pWaypoint);
    }

    public void addAll(WaypointList pList) {
        for (Waypoint tempPoint : pList) {
            this.list.add(tempPoint);
        }
    }

    public void clear() {
        this.list.clear();
    }

    public WaypointList clone() {
        if (this.isPublic) {
            LinkedList<Waypoint> tempList = new LinkedList<Waypoint>();
            for (Waypoint tempPoint : this.list) {
                tempList.add(tempPoint.clone());
            }
            return new WaypointList(this.dim, true, tempList);
        }
        LinkedList<Waypoint> tempList = new LinkedList<Waypoint>();
        for (Waypoint tempPoint : this.list) {
            tempList.add(tempPoint.clone());
        }
        return new WaypointList(this.dim, this.username, tempList);
    }

    public boolean contains(Waypoint pWaypoint) {
        return this.list.contains(pWaypoint);
    }

    public Waypoint get(int index) {
        return this.list.get(index);
    }

    public int getDim() {
        return this.dim;
    }

    public WaypointList getDoublePoints(WaypointList listA) {
        WaypointList duplicates = new WaypointList(this.dim, true);
        for (Waypoint tempA : listA) {
            ListIterator iterator = this.list.listIterator();
            Waypoint tempB = null;
            while (iterator.hasNext()) {
                tempB = (Waypoint)iterator.next();
                if (!tempA.getCompareStr().equalsIgnoreCase(tempB.getCompareStr())) continue;
                duplicates.add(tempB);
            }
        }
        return duplicates;
    }

    public WaypointList getMissingPoints(WaypointList listA) {
        WaypointList missing = new WaypointList(this.dim, this.isPublic);
        for (Waypoint tempA : listA) {
            boolean allreadyIn = false;
            ListIterator iterator = this.list.listIterator();
            Waypoint tempB = null;
            while (iterator.hasNext() && !allreadyIn) {
                tempB = (Waypoint)iterator.next();
                if (!tempA.getCompareStr().equalsIgnoreCase(tempB.getCompareStr())) continue;
                allreadyIn = true;
            }
            if (allreadyIn || tempA.isDeath()) continue;
            missing.add(tempA);
        }
        return missing;
    }

    public WaypointList getWaypointsForName(String pName) {
        WaypointList tempList = new WaypointList(this.dim, true);
        for (Object e : this.list) {
            Waypoint tempPoint = (Waypoint)e;
            if (!tempPoint.getName().equalsIgnoreCase(pName)) continue;
            tempList.add(tempPoint);
        }
        return tempList;
    }

    public WaypointList getWaypointsForNameWithCase(String pName) {
        WaypointList tempList = new WaypointList(this.dim, true);
        for (Object e : this.list) {
            Waypoint tempPoint = (Waypoint)e;
            if (!tempPoint.getName().equals(pName)) continue;
            tempList.add(tempPoint);
        }
        return tempList;
    }

    public int indexOf(Waypoint pWaypoint) {
        return this.list.indexOf(pWaypoint);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<Waypoint> iterator() {
        return this.list.listIterator();
    }

    public ListIterator<Waypoint> listIterator() {
        return this.list.listIterator();
    }

    public boolean remove(Waypoint pWaypoint) {
        return this.list.remove(pWaypoint);
    }

    public boolean removeAll(WaypointList tempList) {
        boolean success = false;
        for (Waypoint p : tempList) {
            success &= this.list.remove(p);
        }
        return success;
    }

    public void setDim(int pDim) {
        this.dim = pDim;
    }

    public int size() {
        return this.list.size();
    }

    public WaypointList getPublic() {
        WaypointList returnList = new WaypointList(this.dim, true);
        for (Waypoint waypoint : this.list) {
            if (!waypoint.isPublic()) continue;
            returnList.add(waypoint);
        }
        return returnList;
    }

    public WaypointList getPrivate() {
        return this.getPublic().getMissingPoints(this);
    }

    public boolean isPrivate() {
        return !this.isPublic;
    }

    public void setPrivate(boolean priv) {
        this.isPublic = !priv;
    }
}

