/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.util.loader;

import cpw.mods.fml.common.FMLCommonHandler;
import james94jeans2.minimapsync.Minimapsync;
import james94jeans2.minimapsync.server.ServerWaypointManager;
import james94jeans2.minimapsync.util.Waypoint;
import james94jeans2.minimapsync.util.WaypointList;
import james94jeans2.minimapsync.util.loader.IWaypointLoader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.dynmap.DynmapCore;
import org.dynmap.forge.DynmapPlugin;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;

public class DynmapLoader
implements IWaypointLoader {
    private MarkerAPI api;
    private boolean initialized = false;
    private boolean forceSave = false;
    private Set<MarkerIcon> icons;

    public DynmapLoader() {
        Thread waitingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Field field = DynmapPlugin.class.getDeclaredField("core");
                    field.setAccessible(true);
                    DynmapCore core = (DynmapCore)field.get(DynmapPlugin.plugin);
                    while (!core.markerAPIInitialized()) {
                    }
                    DynmapLoader.this.api = core.getMarkerAPI();
                }
                catch (NoSuchFieldException e1) {
                    e1.printStackTrace();
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                DynmapLoader.this.icons = new HashSet();
                MarkerIcon icon = DynmapLoader.this.api.getMarkerIcon("mms_icon");
                if (icon != null) {
                    DynmapLoader.this.icons.add(icon);
                } else {
                    try {
                        DynmapLoader.this.icons.add(DynmapLoader.this.api.createMarkerIcon("mms_icon", "minimapsyncIcon", Minimapsync.class.getResource("/assets/mmsmarker.png").openStream()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                DynmapLoader.this.api.createMarkerSet("mms", "waypoints", DynmapLoader.this.icons, false);
                DynmapLoader.this.initialized = true;
                if (DynmapLoader.this.forceSave) {
                    ((ServerWaypointManager)ServerWaypointManager.getInstance()).updateDynmap();
                    DynmapLoader.this.forceSave = false;
                }
            }
        });
        waitingThread.start();
    }

    @Override
    public WaypointList loadWaypointsForDimension(int pDim) {
        return null;
    }

    @Override
    public LinkedList<WaypointList> loadAllWaypoints() {
        return null;
    }

    @Override
    public void saveAllWaypoints(LinkedList<WaypointList> list) {
        if (this.initialized) {
            if (list != null) {
                MarkerSet mms = this.api.getMarkerSet("mms");
                mms.deleteMarkerSet();
                this.api.createMarkerSet("mms", "waypoints", this.icons, false);
                mms = this.api.getMarkerSet("mms");
                for (WaypointList waypointList : list) {
                    String compareString = waypointList.getDim() == 0 ? FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I() : "DIM" + waypointList.getDim();
                    for (Waypoint waypoint : waypointList) {
                        mms.createMarker(null, waypoint.getName(), compareString, (double)waypoint.getXCord(), (double)waypoint.getYCord(), (double)waypoint.getZCord(), this.api.getMarkerIcon("mms_icon"), false);
                    }
                }
            }
        } else {
            this.forceSave = true;
        }
    }

    public void destroy() {
        this.api.getMarkerSet("mms").deleteMarkerSet();
    }
}

