/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.util.loader;

import james94jeans2.minimapsync.util.Waypoint;
import james94jeans2.minimapsync.util.WaypointList;
import james94jeans2.minimapsync.util.loader.IWaypointLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import journeymap.client.model.Waypoint;
import journeymap.client.waypoint.WaypointStore;

public class JourneyMapLoader
implements IWaypointLoader {
    @Override
    public WaypointList loadWaypointsForDimension(int pDim) {
        WaypointList returnList = new WaypointList(pDim, true);
        Collection waypoints = WaypointStore.instance().getAll();
        for (journeymap.client.model.Waypoint waypoint : waypoints) {
            Collection dimensions = waypoint.getDimensions();
            if (waypoint.isDeathPoint()) continue;
            for (Integer integer : dimensions) {
                if (integer != pDim) continue;
                returnList.add(new Waypoint(waypoint.getName(), waypoint.getX(), waypoint.getY(), waypoint.getZ(), waypoint.isEnable(), waypoint.getR(), waypoint.getG(), waypoint.getB(), dimensions, pDim, false));
            }
        }
        return returnList.isEmpty() ? null : returnList;
    }

    @Override
    public LinkedList<WaypointList> loadAllWaypoints() {
        LinkedList<WaypointList> returnList = new LinkedList<WaypointList>();
        TreeSet dimensions = new TreeSet();
        Collection waypoints = WaypointStore.instance().getAll();
        for (journeymap.client.model.Waypoint waypoint : waypoints) {
            dimensions.addAll(waypoint.getDimensions());
        }
        Iterator iterator = dimensions.iterator();
        while (iterator.hasNext()) {
            int dim = (Integer)iterator.next();
            WaypointList tempList = this.loadWaypointsForDimension(dim);
            if (tempList == null) continue;
            returnList.add(tempList);
        }
        return returnList.isEmpty() ? null : returnList;
    }

    @Override
    public void saveAllWaypoints(LinkedList<WaypointList> list) {
        for (WaypointList waypointList : list) {
            this.saveWaypointsForDimension(waypointList);
        }
    }

    public void saveWaypointsForDimension(WaypointList toSave) {
        ArrayList<Integer> dimensions;
        int dimse = toSave.getDim();
        LinkedList<journeymap.client.model.Waypoint> waypointsToDelete = new LinkedList<journeymap.client.model.Waypoint>();
        Collection all = WaypointStore.instance().getAll();
        for (journeymap.client.model.Waypoint waypoint : all) {
            dimensions = waypoint.getDimensions();
            if (waypoint.isDeathPoint()) continue;
            for (Integer integer : dimensions) {
                if (integer != dimse) continue;
                waypointsToDelete.add(waypoint);
            }
        }
        for (journeymap.client.model.Waypoint waypoint : waypointsToDelete) {
            WaypointStore.instance().remove(waypoint);
        }
        for (Waypoint waypoint : toSave) {
            dimensions = new ArrayList<Integer>();
            Object object = waypoint.getDims();
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Integer integer = (int)object[i];
                dimensions.add(integer);
            }
            WaypointStore.instance().save(new journeymap.client.model.Waypoint(waypoint.getName(), waypoint.getXCord(), waypoint.getYCord(), waypoint.getZCord(), waypoint.getVisible(), waypoint.getFirstColor(), waypoint.getSecondColor(), waypoint.getThirdColor(), Waypoint.Type.Normal, Waypoint.Origin.JourneyMap, Integer.valueOf(waypoint.getDim()), dimensions));
        }
    }
}

