/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.util.loader;

import cpw.mods.fml.common.FMLCommonHandler;
import james94jeans2.minimapsync.Minimapsync;
import james94jeans2.minimapsync.util.FileReader;
import james94jeans2.minimapsync.util.Waypoint;
import james94jeans2.minimapsync.util.WaypointList;
import james94jeans2.minimapsync.util.loader.IWaypointLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerLoader
implements IWaypointLoader {
    private String folder;
    private String file;
    private StringBuilder fileName;
    private FileReader dimensionReader;
    private FileReader waypointReader;
    private File save;

    public PlayerLoader(String pFolder) {
        this.folder = pFolder;
    }

    public PlayerLoader() {
        this.fileName = new StringBuilder();
        this.fileName.append(FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I());
        this.fileName.append("/waypoints/players");
        this.folder = this.fileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WaypointList loadWaypointsForDimension(int pDim) {
        WaypointList returnList = new WaypointList(pDim, false);
        this.fileName = new StringBuilder();
        this.fileName.append(this.folder);
        this.fileName.append("/DIM");
        this.fileName.append(pDim);
        this.fileName.append(".minimapsync");
        this.file = this.fileName.toString();
        try {
            this.waypointReader = new FileReader(this.file);
            while (this.waypointReader.hasNextLine()) {
                returnList.add(new Waypoint(this.waypointReader.readNextLine(), pDim, false));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (this.waypointReader != null) {
                this.waypointReader.closeScanner();
            }
            this.waypointReader = null;
        }
        return returnList.isEmpty() ? null : returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedList<WaypointList> loadAllWaypoints() {
        this.fileName = new StringBuilder();
        this.fileName.append(this.folder);
        this.fileName.append("/dimensions.minimapsync");
        this.file = this.fileName.toString();
        LinkedList<WaypointList> returnList = null;
        try {
            this.dimensionReader = new FileReader(this.file);
            TreeSet<Integer> dimensions = new TreeSet<Integer>();
            while (this.dimensionReader.hasNextLine()) {
                dimensions.add(Integer.parseInt(this.dimensionReader.readNextLine()));
            }
            returnList = new LinkedList<WaypointList>();
            WaypointList addList = null;
            for (Integer integer : dimensions) {
                addList = this.loadWaypointsForDimension(integer);
                if (addList == null) continue;
                returnList.add(addList);
            }
            if (returnList.isEmpty()) {
                returnList = null;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (this.dimensionReader != null) {
                this.dimensionReader.closeScanner();
            }
            this.dimensionReader = null;
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWaypointsForDimension(WaypointList list) {
        this.fileName = new StringBuilder();
        this.fileName.append(this.folder);
        this.fileName.append("/DIM");
        this.fileName.append(list.getDim());
        this.fileName.append(".minimapsync");
        this.file = this.fileName.toString();
        this.save = new File(this.file);
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(this.save);
            for (Waypoint waypoint : list) {
                fw.write(waypoint.getServerLine() + "\n");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAllWaypoints(LinkedList<WaypointList> list) {
        boolean saved = false;
        if (list == null || list.isEmpty()) {
            this.fileName = new StringBuilder();
            this.fileName.append(this.folder);
            this.fileName.append("/dimensions.minimapsync");
            this.file = this.fileName.toString();
            this.save = new File(this.file);
            this.save.delete();
            this.save = new File(this.folder);
            if (this.save.listFiles() != null) {
                for (File file : this.save.listFiles()) {
                    String fileExtension = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(46));
                    if (!fileExtension.equalsIgnoreCase(".minimapsync")) continue;
                    file.delete();
                }
            }
            return;
        }
        this.file = this.folder;
        this.save = new File(this.file);
        if (!this.save.exists()) {
            this.save.mkdirs();
        }
        this.fileName = new StringBuilder();
        this.fileName.append(this.folder);
        this.fileName.append("/dimensions.minimapsync");
        this.file = this.fileName.toString();
        this.save = new File(this.file);
        FileWriter fw = null;
        boolean written = false;
        try {
            fw = new FileWriter(this.save);
            for (WaypointList wlist : list) {
                if (wlist.isEmpty()) continue;
                fw.write(wlist.getDim() + "\n");
                written = true;
            }
            if (!written) {
                fw.close();
                this.save.delete();
            }
            saved = written;
        }
        catch (IOException e) {
            Minimapsync.instance.logger.fatal("Unable to save waypoints!");
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (saved) {
            for (WaypointList waypointList : list) {
                if (!waypointList.isEmpty()) {
                    this.saveWaypointsForDimension(waypointList);
                    continue;
                }
                this.fileName = new StringBuilder();
                this.fileName.append(this.folder);
                this.fileName.append("/DIM");
                this.fileName.append(waypointList.getDim());
                this.fileName.append(".minimapsync");
                this.file = this.fileName.toString();
                this.save = new File(this.file);
                this.save.delete();
            }
        } else {
            for (WaypointList wlist : list) {
                this.fileName = new StringBuilder();
                this.fileName.append(this.folder);
                this.fileName.append("/DIM");
                this.fileName.append(wlist.getDim());
                this.fileName.append(".minimapsync");
                this.file = this.fileName.toString();
                this.save = new File(this.file);
                this.save.delete();
            }
        }
    }

    public IWaypointLoader createLoader(EntityPlayer player) {
        StringBuilder newFolder = new StringBuilder(this.folder);
        newFolder.append("/" + player.func_70005_c_());
        return new PlayerLoader(newFolder.toString());
    }
}

