/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.util.loader;

import com.thevoxelbox.voxelmap.interfaces.AbstractVoxelMap;
import com.thevoxelbox.voxelmap.interfaces.IWaypointManager;
import james94jeans2.minimapsync.util.Waypoint;
import james94jeans2.minimapsync.util.WaypointList;
import james94jeans2.minimapsync.util.loader.IWaypointLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;

public class VoxelmapLoader
implements IWaypointLoader {
    @Override
    public WaypointList loadWaypointsForDimension(int pDim) {
        WaypointList waypointsInDimension = new WaypointList(pDim, true);
        ArrayList waypoints = AbstractVoxelMap.getInstance().getWaypointManager().getWaypoints();
        for (com.thevoxelbox.voxelmap.util.Waypoint waypoint : waypoints) {
            if (!waypoint.dimensions.contains(pDim) && waypoint.dimensions.size() != 0) continue;
            waypointsInDimension.add(new Waypoint(true, waypoint.name, waypoint.x, waypoint.y, waypoint.z, waypoint.enabled, waypoint.red, waypoint.green, waypoint.blue, waypoint.imageSuffix, waypoint.dimensions, pDim, false));
        }
        return waypointsInDimension.isEmpty() ? null : waypointsInDimension;
    }

    @Override
    public LinkedList<WaypointList> loadAllWaypoints() {
        Set<Integer> loadedDimensions = this.getDimensions();
        if (loadedDimensions != null) {
            LinkedList<WaypointList> returnLists = new LinkedList<WaypointList>();
            Iterator<Integer> iterator = loadedDimensions.iterator();
            WaypointList newList = null;
            while (iterator.hasNext()) {
                newList = this.loadWaypointsForDimension(iterator.next());
                if (newList == null) continue;
                returnLists.add(newList);
            }
            return returnLists.isEmpty() ? null : returnLists;
        }
        return null;
    }

    public void saveWaypointsForDimension(WaypointList list) {
        WaypointList tempList = this.loadWaypointsForDimension(list.getDim());
        if (tempList == null) {
            tempList = new WaypointList(list.getDim(), true);
        }
        WaypointList toAdd = tempList.getMissingPoints(list);
        WaypointList toDelete = list.getMissingPoints(tempList);
        ArrayList waypoints = AbstractVoxelMap.getInstance().getWaypointManager().getWaypoints();
        block0: for (Waypoint wp : toDelete) {
            for (Object waypoint : waypoints) {
                Waypoint comp;
                if (!((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).dimensions.contains(wp.getDim()) && ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).dimensions.size() != 0 || !(comp = new Waypoint(true, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).name, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).x, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).y, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).z, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).enabled, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).red, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).green, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).blue, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).imageSuffix, ((com.thevoxelbox.voxelmap.util.Waypoint)waypoint).dimensions, wp.getDim(), false)).getCompareStr().equals(wp.getCompareStr())) continue;
                waypoints.remove(waypoint);
                continue block0;
            }
        }
        TreeSet<Integer> dimension = new TreeSet<Integer>();
        dimension.add(list.getDim());
        IWaypointManager manager = AbstractVoxelMap.getInstance().getWaypointManager();
        for (Object waypoint : toAdd) {
            com.thevoxelbox.voxelmap.util.Waypoint addPoint = new com.thevoxelbox.voxelmap.util.Waypoint(((Waypoint)waypoint).getName(), ((Waypoint)waypoint).getZanXCord(), ((Waypoint)waypoint).getZanZCord(), ((Waypoint)waypoint).getZanYCord(), true, ((Waypoint)waypoint).getR(), ((Waypoint)waypoint).getG(), ((Waypoint)waypoint).getB(), "", "", dimension);
            manager.addWaypoint(addPoint);
        }
    }

    @Override
    public void saveAllWaypoints(LinkedList<WaypointList> list) {
        for (WaypointList waypointList : list) {
            this.saveWaypointsForDimension(waypointList);
        }
        ArrayList waypoints = AbstractVoxelMap.getInstance().getWaypointManager().getWaypoints();
        int dim = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        for (com.thevoxelbox.voxelmap.util.Waypoint waypoint : waypoints) {
            if (waypoint.dimensions.size() == 0 || waypoint.dimensions.contains(dim)) {
                waypoint.inDimension = true;
                continue;
            }
            waypoint.inDimension = false;
        }
    }

    private Set<Integer> getDimensions() {
        TreeSet<Integer> loaded = new TreeSet<Integer>();
        ArrayList waypoints = AbstractVoxelMap.getInstance().getWaypointManager().getWaypoints();
        for (com.thevoxelbox.voxelmap.util.Waypoint waypoint : waypoints) {
            loaded.addAll(waypoint.dimensions);
        }
        return loaded.isEmpty() ? null : loaded;
    }
}

