/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.helper;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectCharHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.unidict.MetaItem;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.UniResourceContainer;

public final class RecipeHelper {
    public static final List<IRecipe> recipes = CraftingManager.func_77594_a().func_77592_b();
    private static final char[] DEFAULT_RECIPE_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I'};

    private RecipeHelper() {
    }

    @Nonnull
    public static Object[] rawShapeToShape(@Nonnull Object[] objects) {
        int f = 0;
        char[][] almostTheShape = new char[][]{{' ', ' ', ' '}, {' ', ' ', ' '}, {' ', ' ', ' '}};
        TObjectCharHashMap thingToCharMap = new TObjectCharHashMap();
        THashMap keyStackMap = new THashMap();
        boolean done = false;
        for (int x = 0; x < 3 && !done; ++x) {
            for (int y = 0; y < 3 && !done; ++y) {
                Object key;
                int value = x * 3 + y;
                done = value >= objects.length;
                if (done || objects[value] == null) continue;
                Object object = key = objects[value] instanceof ItemStack ? Integer.valueOf(MetaItem.get((ItemStack)objects[value])) : objects[value];
                if (key instanceof Integer) {
                    keyStackMap.put((Integer)key, (ItemStack)objects[value]);
                }
                if (thingToCharMap.containsKey(key)) {
                    almostTheShape[x][y] = thingToCharMap.get(key);
                    continue;
                }
                char c = DEFAULT_RECIPE_CHARS[f++];
                almostTheShape[x][y] = c;
                thingToCharMap.put(key, c);
            }
        }
        Object[] shape = Arrays.copyOf(new Object[]{new String(almostTheShape[0]), new String(almostTheShape[1]), new String(almostTheShape[2])}, 3 + thingToCharMap.size() * 2);
        int i = 0;
        for (Object object : thingToCharMap.keySet()) {
            shape[3 + 2 * i] = Character.valueOf(thingToCharMap.get(object));
            shape[4 + 2 * i++] = object instanceof Integer ? keyStackMap.get(object) : object;
        }
        return shape;
    }

    public static void singleWayCompressionRecipe(@Nonnull List<Resource> smallerAndBiggerResources, long smaller, long bigger) {
        smallerAndBiggerResources.forEach(r -> recipes.add((IRecipe)new ShapedOreRecipe(r.getChild(bigger).getMainEntry(), new Object[]{"SSS", "SSS", "SSS", Character.valueOf('S'), r.getChild((long)smaller).name})));
    }

    public static void resourcesToCompressionRecipes(@Nonnull Collection<Resource> resources, long ... smallerToBigger) {
        for (Resource resource : resources) {
            for (int i = 0; i < smallerToBigger.length - 1; ++i) {
                UniResourceContainer bigger;
                UniResourceContainer smaller = resource.getChild(smallerToBigger[i]);
                if (smaller == null || (bigger = resource.getChild(smallerToBigger[i + 1])) == null) continue;
                RecipeHelper.createCompressionRecipe(smaller, bigger);
            }
        }
    }

    private static void createCompressionRecipe(@Nonnull UniResourceContainer smaller, UniResourceContainer bigger) {
        recipes.add((IRecipe)new ShapedOreRecipe(bigger.getMainEntry(), new Object[]{"SSS", "SSS", "SSS", Character.valueOf('S'), smaller.name}));
        recipes.add((IRecipe)new ShapelessOreRecipe(smaller.getMainEntry(9), new Object[]{bigger.name}));
    }
}

