/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.google.common.collect.Lists;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.common.Util;
import wanion.unidict.helper.RecipeHelper;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.recipe.ForgeRecipeResearcher;
import wanion.unidict.recipe.IC2RecipeResearcher;
import wanion.unidict.recipe.IRecipeResearcher;
import wanion.unidict.recipe.VanillaRecipeResearcher;
import wanion.unidict.resource.UniResourceContainer;

final class CraftingIntegration
extends AbstractIntegrationThread {
    private final UniOreDictionary uniOreDictionary = UniDict.getDependencies().get(UniOreDictionary.class);
    private final List<IRecipe> recipes = RecipeHelper.recipes;
    private final Map<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>> shapedResearcherMap = new IdentityHashMap<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>>();
    private final Map<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>> shapelessResearcherMap = new IdentityHashMap<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>>();

    CraftingIntegration() {
        super("Crafting");
        ArrayList<IRecipeResearcher<ShapedRecipes, ShapelessRecipes>> researcherList = new ArrayList<IRecipeResearcher<ShapedRecipes, ShapelessRecipes>>();
        researcherList.add(new VanillaRecipeResearcher());
        researcherList.add(new ForgeRecipeResearcher());
        if (Config.ic2) {
            researcherList.add(new IC2RecipeResearcher());
        }
        researcherList.forEach(researcher -> {
            researcher.getShapedRecipeClasses().forEach(shapedRecipeClass -> this.shapedResearcherMap.put((Class<? extends IRecipe>)shapedRecipeClass, (IRecipeResearcher<? extends IRecipe, ? extends IRecipe>)researcher));
            researcher.getShapelessRecipeClasses().forEach(shapelessRecipeClass -> this.shapelessResearcherMap.put((Class<? extends IRecipe>)shapelessRecipeClass, (IRecipeResearcher<? extends IRecipe, ? extends IRecipe>)researcher));
        });
    }

    @Override
    public String call() {
        try {
            this.doTheResearch();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "Why so many recipes? I had to deal with a lot of recipes.";
    }

    private void doTheResearch() {
        THashMap smartRecipeMap = new THashMap();
        Iterator<IRecipe> recipeIterator = this.recipes.iterator();
        while (recipeIterator.hasNext()) {
            int recipeKey;
            UniResourceContainer bufferContainer;
            boolean isShapeless = false;
            IRecipe bufferRecipe = recipeIterator.next();
            if (bufferRecipe == null || (bufferContainer = this.resourceHandler.getContainer(bufferRecipe.func_77571_b())) == null || !this.shapedResearcherMap.containsKey(bufferRecipe.getClass()) && !(isShapeless = this.shapelessResearcherMap.containsKey(bufferRecipe.getClass()))) continue;
            int n = recipeKey = !isShapeless ? this.shapedResearcherMap.get(bufferRecipe.getClass()).getShapedRecipeKey(bufferRecipe, this.resourceHandler) : this.shapelessResearcherMap.get(bufferRecipe.getClass()).getShapelessRecipeKey(bufferRecipe, this.resourceHandler);
            if (recipeKey != 0 && bufferRecipe.func_77570_a() > 0) {
                TIntObjectMap evenSmarterRecipeMap;
                if (!smartRecipeMap.containsKey(bufferContainer)) {
                    evenSmarterRecipeMap = new TIntObjectHashMap();
                    smartRecipeMap.put(bufferContainer, evenSmarterRecipeMap);
                } else {
                    evenSmarterRecipeMap = (TIntObjectMap)smartRecipeMap.get(bufferContainer);
                }
                if (!evenSmarterRecipeMap.containsKey(recipeKey)) {
                    evenSmarterRecipeMap.put(recipeKey, (Object)Lists.newArrayList((Object[])new IRecipe[]{bufferRecipe}));
                } else {
                    ((List)evenSmarterRecipeMap.get(recipeKey)).add(bufferRecipe);
                }
            }
            recipeIterator.remove();
        }
        TLongObjectHashMap kindSpecificRecipeComparatorMap = Config.enableSpecificKindSort ? new TLongObjectHashMap() : null;
        RecipeComparator normalRecipeComparator = !Config.enableSpecificKindSort ? new RecipeComparator(Util.itemStackComparatorByModName) : null;
        smartRecipeMap.forEach((arg_0, arg_1) -> this.lambda$doTheResearch$4((TLongObjectMap)kindSpecificRecipeComparatorMap, normalRecipeComparator, arg_0, arg_1));
    }

    private /* synthetic */ void lambda$doTheResearch$4(TLongObjectMap kindSpecificRecipeComparatorMap, RecipeComparator normalRecipeComparator, UniResourceContainer container, TIntObjectMap evenSmartRecipeMap) {
        evenSmartRecipeMap.forEachValue(recipeList -> {
            IRecipeResearcher<? extends IRecipe, ? extends IRecipe> recipeResearcher;
            RecipeComparator recipeComparator;
            if (kindSpecificRecipeComparatorMap != null) {
                if (kindSpecificRecipeComparatorMap.containsKey(container.kind)) {
                    recipeComparator = (RecipeComparator)kindSpecificRecipeComparatorMap.get(container.kind);
                } else {
                    recipeComparator = new RecipeComparator(container.getComparator());
                    kindSpecificRecipeComparatorMap.put(container.kind, (Object)recipeComparator);
                }
            } else {
                recipeComparator = normalRecipeComparator;
            }
            recipeList.sort(recipeComparator);
            IRecipe recipe = (IRecipe)recipeList.get(0);
            boolean isShapeless = this.shapelessResearcherMap.containsKey(recipe.getClass());
            IRecipeResearcher<? extends IRecipe, ? extends IRecipe> iRecipeResearcher = recipeResearcher = !isShapeless ? this.shapedResearcherMap.get(recipe.getClass()) : this.shapelessResearcherMap.get(recipe.getClass());
            if (recipe.func_77570_a() == 9) {
                this.recipes.add((IRecipe)(isShapeless ? recipeResearcher.getNewShapedFromShapelessRecipe(recipe, this.resourceHandler, this.uniOreDictionary) : recipeResearcher.getNewShapedRecipe(recipe, this.resourceHandler, this.uniOreDictionary)));
            } else if (recipe.func_77570_a() == 1) {
                this.recipes.add((IRecipe)(isShapeless ? recipeResearcher.getNewShapelessRecipe(recipe, this.resourceHandler, this.uniOreDictionary) : recipeResearcher.getNewShapelessFromShapedRecipe(recipe, this.resourceHandler, this.uniOreDictionary)));
            } else {
                this.recipes.add((IRecipe)(isShapeless ? recipeResearcher.getNewShapelessRecipe(recipe, this.resourceHandler, this.uniOreDictionary) : recipeResearcher.getNewShapedRecipe(recipe, this.resourceHandler, this.uniOreDictionary)));
            }
            return true;
        });
    }

    private class RecipeComparator
    implements Comparator<IRecipe> {
        private final Comparator<ItemStack> itemStackComparator;

        private RecipeComparator(Comparator<ItemStack> itemStackComparator) {
            this.itemStackComparator = itemStackComparator;
        }

        @Override
        public int compare(IRecipe o1, IRecipe o2) {
            return this.itemStackComparator.compare(o1.func_77571_b(), o2.func_77571_b());
        }
    }
}

