/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class FurnaceIntegration
extends AbstractIntegrationThread {
    FurnaceIntegration() {
        super("Furnace");
    }

    @Override
    public String call() {
        try {
            this.optimizeFurnaceRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "Some things that you smelted appear to be different now.";
    }

    private void optimizeFurnaceRecipes() {
        if (!Config.inputReplacement) {
            for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
                entry.setValue(this.resourceHandler.getMainItemStack((ItemStack)entry.getValue()));
            }
        } else {
            IdentityHashMap<UniResourceContainer, TLongHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TLongHashSet>();
            Map map = FurnaceRecipes.func_77602_a().func_77599_b();
            HashMap<ItemStack, ItemStack> newRecipes = new HashMap<ItemStack, ItemStack>();
            Iterator furnaceRecipeIterator = map.entrySet().iterator();
            while (furnaceRecipeIterator.hasNext()) {
                TLongSet kindSet;
                Map.Entry furnaceRecipe = furnaceRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer((ItemStack)furnaceRecipe.getKey());
                UniResourceContainer outputContainer = this.resourceHandler.getContainer((ItemStack)furnaceRecipe.getValue());
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    furnaceRecipe.setValue(outputContainer.getMainEntry(((ItemStack)furnaceRecipe.getValue()).field_77994_a));
                    continue;
                }
                long kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TLongHashSet());
                }
                if (!(kindSet = (TLongSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    newRecipes.put(inputContainer.getMainEntry(((ItemStack)furnaceRecipe.getKey()).field_77994_a), outputContainer.getMainEntry(((ItemStack)furnaceRecipe.getValue()).field_77994_a));
                }
                furnaceRecipeIterator.remove();
            }
            map.putAll(newRecipes);
        }
    }
}

