/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import wanion.unidict.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.common.FixedSizeList;
import wanion.unidict.integration.AbstractIntegrationThread;

final class IEIntegration
extends AbstractIntegrationThread {
    IEIntegration() {
        super("Immersive Engineering");
    }

    @Override
    public String call() {
        try {
            this.fixArcFurnaceRecipes();
            this.fixBlastFurnaceRecipes();
            this.fixCrusherRecipes();
            this.fixMetalPressRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "The world's engineer appears to be more immersive.";
    }

    private void fixArcFurnaceRecipes() {
        ArrayList arcFurnaceRecipes = ArcFurnaceRecipe.recipeList;
        ArrayList<ArcFurnaceRecipe> correctRecipes = new ArrayList<ArcFurnaceRecipe>(new Double((double)arcFurnaceRecipes.size() * 1.3).intValue());
        Iterator arcFurnaceRecipeIterator = arcFurnaceRecipes.iterator();
        while (arcFurnaceRecipeIterator.hasNext()) {
            ArcFurnaceRecipe recipe = (ArcFurnaceRecipe)arcFurnaceRecipeIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(recipe.output);
            if (correctOutput == recipe.output) continue;
            correctRecipes.add(new ArcFurnaceRecipe(correctOutput, (Object)recipe.oreInputString, recipe.slag, recipe.time, recipe.energyPerTick, recipe.additives));
            arcFurnaceRecipeIterator.remove();
        }
        arcFurnaceRecipes.addAll(correctRecipes);
    }

    private void fixBlastFurnaceRecipes() {
        ArrayList correctRecipes = new ArrayList(new Double((double)BlastFurnaceRecipe.recipeList.size() * 1.3).intValue());
        correctRecipes.addAll(BlastFurnaceRecipe.recipeList.stream().map(blastFurnaceRecipe -> new BlastFurnaceRecipe(this.resourceHandler.getMainItemStack(blastFurnaceRecipe.output), blastFurnaceRecipe.input, blastFurnaceRecipe.time, blastFurnaceRecipe.slag)).collect(Collectors.toList()));
        BlastFurnaceRecipe.recipeList.clear();
        BlastFurnaceRecipe.recipeList.addAll(correctRecipes);
    }

    private void fixCrusherRecipes() {
        ArrayList crusherRecipes = CrusherRecipe.recipeList;
        FixedSizeList<CrusherRecipe> correctRecipes = new FixedSizeList<CrusherRecipe>(crusherRecipes.size());
        TIntHashSet uniques = new TIntHashSet(crusherRecipes.size(), 1.0f);
        Iterator crusherRecipesIterator = crusherRecipes.iterator();
        while (crusherRecipesIterator.hasNext()) {
            CrusherRecipe crusherRecipe = (CrusherRecipe)crusherRecipesIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(crusherRecipe.output);
            if (correctOutput == crusherRecipe.output) continue;
            ItemStack input = UniOreDictionary.getFirstEntry(crusherRecipe.oreInputString);
            int recipeId = MetaItem.getCumulative(input, correctOutput);
            if (!uniques.contains(recipeId)) {
                if (crusherRecipe.secondaryOutput == null) {
                    correctRecipes.add(new CrusherRecipe(correctOutput, crusherRecipe.input, crusherRecipe.energy));
                } else {
                    correctRecipes.add(new UniCrusherRecipe(correctOutput, crusherRecipe.input, crusherRecipe.energy, this.resourceHandler.getMainItemStacks(crusherRecipe.secondaryOutput), crusherRecipe.secondaryChance));
                }
                uniques.add(recipeId);
            }
            crusherRecipesIterator.remove();
        }
        crusherRecipes.addAll(correctRecipes);
    }

    private void fixMetalPressRecipes() {
        ArrayListMultimap metalPressRecipes = MetalPressRecipe.recipeList;
        ArrayListMultimap correctRecipes = ArrayListMultimap.create();
        TIntHashSet uniques = new TIntHashSet(metalPressRecipes.size(), 1.0f);
        Iterator metalPressRecipesIterator = metalPressRecipes.values().iterator();
        while (metalPressRecipesIterator.hasNext()) {
            MetalPressRecipe metalPressRecipe = (MetalPressRecipe)metalPressRecipesIterator.next();
            ItemStack output = this.resourceHandler.getMainItemStack(metalPressRecipe.output);
            if (output == metalPressRecipe.output) continue;
            int id = MetaItem.getCumulative(output, metalPressRecipe.mold.stack);
            if (!uniques.contains(id)) {
                correctRecipes.put((Object)metalPressRecipe.mold, (Object)new MetalPressRecipe(output, metalPressRecipe.input, metalPressRecipe.mold.stack, metalPressRecipe.energy));
                uniques.add(id);
            }
            metalPressRecipesIterator.remove();
        }
        metalPressRecipes.putAll((Multimap)correctRecipes);
    }

    private static final class UniCrusherRecipe
    extends CrusherRecipe {
        private UniCrusherRecipe(ItemStack output, Object input, int energy, ItemStack[] secondaryOutputs, float[] secondaryChances) {
            super(output, input, energy);
            this.secondaryOutput = secondaryOutputs;
            this.secondaryChance = secondaryChances;
        }
    }
}

